%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  repe.cls
%  Classe criada para submissão de artigos à 
%  Revista Eletrônica Engenharia & Produção
%  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{repe}[2024/12/28 v1.0 AAMPicorone]
\LoadClass{article}


%----------------------------------------------------------
%                    Pacotes iniciais
%----------------------------------------------------------

% desativa a hifenação
\RequirePackage{hyphenat}
\tolerance=1
\emergencystretch=\maxdimen
\hyphenpenalty=10000
\hbadness=10000
\hyphenchar\font=-1
\sloppy




\RequirePackage[utf8]{inputenc}
\RequirePackage[brazil]{babel}
\RequirePackage[T1]{fontenc}    		%aceita acentos

\RequirePackage{amsmath,amssymb,amsfonts} 
\RequirePackage{color}          		%para alterar cores do texto
\RequirePackage{xcolor}
\RequirePackage{graphicx}         		

\RequirePackage{etoolbox}               %permite testes condicionais

\RequirePackage[portuguese, ruled, linesnumbered]{algorithm2e} %formata os algoritmos     
\RequirePackage{indentfirst}   			%identa o 1º parágrafo de cada seção
\RequirePackage[normalem]{ulem} 		%sublinhar de diversar formas o texto

%----------------------------------------------------------
%                       Page
%----------------------------------------------------------
\setlength{\headheight}{34pt} 			%menor valor para o fancy
\newlength{\topmarginheight} 			%margem do topo do papel ao topo do texto
\setlength{\topmarginheight}{1.5cm}
\newlength{\headersep} 					%margem de baixo do cabeçalho até o top do texto
\setlength{\headersep}{\topmarginheight}
\addtolength{\headersep}{-\headheight}
\addtolength{\headersep}{-1.3cm}
\RequirePackage[left=2cm,right=2cm,top=\topmarginheight,bottom=1.2cm,headsep=\headersep]{geometry}

\RequirePackage{pbox} 					% \pbox é como o \parbox mas determina a caixa automaticamente



%----------------------------------------------------------
%                       Paragragh
%----------------------------------------------------------
\setlength{\parskip}{0.2cm}   			%Espaçamento entre parágrafos
\setlength{\parindent}{.8cm} 			%Espaçamento lateral do parágrafo (indent)

\RequirePackage{setspace}    			%altera o espaçamento entre linhas
\singlespacing   						%Espaçamento simples

%----------------------------------------------------------
%                       Font
%----------------------------------------------------------
% Usa fonte Adobe Times Roman como fonte padrão do texto juntamente com símbolos matemáticos do Symbol, Chancery e Computer Modern
\RequirePackage{mathptmx}
\renewcommand{\@xpt}{12}
\renewcommand{\@xiipt}{13.5}
\renewcommand\normalsize{%
	\@setfontsize\normalsize\@xpt\@xiipt
	\abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
	\abovedisplayshortskip \z@ \@plus3\p@
	\belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
	\belowdisplayskip \abovedisplayskip
	\let\@listi\@listI} 

%----------------------------------------------------------
%                headers e footers
%----------------------------------------------------------
\RequirePackage{fancyhdr}          		% customiza headers/footers
\renewcommand{\headrulewidth}{0pt} 		% retira a barra entre headers/footers e o corpo do texto 

\fancypagestyle{todas}{
	\fancyhf{}
}
\fancyhfoffset[H]{45pt}

\newenvironment{corresp}[1]
    {\small
    \vfill
    {\flushleft \rule{10cm}{.2pt}}\\
    {\bf Autor correspondente:} #1 \newpage }



%----------------------------------------------------------
%                  Title e author
%----------------------------------------------------------
\newbool{versao}
\DeclareOption{versaoAvaliacao}{\setbool{versao}{false}}
\DeclareOption{versaoFinal}{\setbool{versao}{true}}
\ProcessOptions\relax

\providecommand{\versaodoc}{versao} 


\RequirePackage{titling} 				%permite customizar o \maketitle
\pretitle{\vspace{-5pt} \centering \fontsize{15pt}{15pt}\selectfont \bf \color{teal}}   
\posttitle{\par}
\preauthor{\vspace{24pt} \centering \fontsize{12pt}{14pt}\selectfont}
\postauthor{\\}
\predate{} % remove datas
\date{ }
\postdate{\vspace{20pt} \thispagestyle{todas}}


\AfterPreamble{
\ifbool{versao}{
% versaoFinal
\author{\autor}
\affil[]{\afiliacao}
\providecommand{\autorcorresp}{\correspondente} 
}
{
%versaoAvaliacao
\author{{\color{red}{\large Versão de avaliação - os nomes dos autores só aparecerão na versão final}}}
\providecommand{\autorcorresp}{{\color{red}{Versão de avaliação - o nome do autor correspondente só aparecerá na versão final}}} 
}
\pagestyle{todas}
}

\RequirePackage{authblk}
\renewcommand*{\Authsep}{, }
\renewcommand*{\Authand}{, }
\renewcommand*{\Authands}{, }
\renewcommand*{\Affilfont}{\normalsize\normalfont}
\renewcommand*{\Authfont}{\bfseries}    % make author names boldface    
\setlength{\affilsep}{2em}   % set the space between author and affiliation

\AtBeginDocument{
	
\maketitle
\thispagestyle{todas}
}

%----------------------------------------------------------
%                    Abstract e Keywords 
%----------------------------------------------------------
\newenvironment{resumo}{\fontsize{12pt}{14pt}\selectfont  
    \begin{center}
        \large
        \textbf{\color{teal} Resumo}
    \end{center}}
    
\newenvironment{palavrasChave}{\vspace{-10pt}  \flushleft \fontsize{12pt}{14pt}\selectfont  {\color{teal} \textbf{Palavras-chave:}}}

\renewenvironment{abstract}{\noindent \fontsize{12pt}{14pt}\selectfont \itshape 
    \begin{center}
        \textbf{\color{teal}\large Abstract}
    \end{center}}
    
\newenvironment{keywords}{\vspace{-10pt}  \flushleft \fontsize{12pt}{14pt}\selectfont \itshape {\color{teal}\textbf{Keywords:}}}

%----------------------------------------------------------
%             Section e subsection
%----------------------------------------------------------
\RequirePackage{titlesec} 				%customiza \section

 \titleformat{\section}{\color{teal} \fontsize{14pt}{14pt}\normalfont\bfseries}{}{0em}{\thesection .\quad}
\titlespacing*{\section}{0pt}{10pt}{2pt}

\titleformat{\subsection}{\color{teal} \fontsize{12pt}{12pt}\normalfont\bfseries}{}{-.5em}{\thesubsection \quad}
\titlespacing*{\subsection}{6pt}{5pt}{0pt}

%----------------------------------------------------------
%                   Appendix
%----------------------------------------------------------
\def\appendix{
	\setcounter{section}{0}
	\titleformat{\section}{\color{teal} \fontsize{13pt}{13pt}\normalfont\bfseries}{}{0em}{ANEXO \Alph{section} \textendash \quad}
	\titlespacing*{\section}{0pt}{15pt}{7pt}
}


% %----------------------------------------------------------
% %                   Captions
% %----------------------------------------------------------
\RequirePackage{caption} 				%customiza os captions

% Figures
\addto\captionsbrazil{
	\renewcommand{\figurename}{\color{teal} \fontsize{10pt}{13pt}\selectfont FIGURA} 
	\def \from#1{ \fontsize{10pt}{11.5pt}\selectfont
		\begin{center} #1 \end{center}}}

% Tables
\addto\captionsbrazil{
	\renewcommand{\tablename}{\color{teal} \fontsize{10pt}{13pt}\selectfont TABELA} 
	\def \from#1{ \fontsize{10pt}{11.5pt}\selectfont
		\begin{center} #1 \end{center}}}

% Algoritmo
\SetAlgorithmName{\color{teal} Algoritmo}




